/*
 * @(#)CERISA.java  1.1  2006-02-21
 *
 * Copyright (c) 2006 Lucerne University of Applied Sciences and Arts (HSLU)
 * Zentralstrasse 18, Postfach 2858, CH-6002 Lucerne, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by the Lucerne University of Applied 
 * Sciences and Arts (HSLU). You may not use, copy or modify this software, 
 * except in accordance with the license agreement you entered into with HSLU. 
 * For details see accompanying license terms. 
 */

package ch.hslu.cm.cer.model;

import ch.randelshofer.util.*;
import ch.hslu.cm.simulation.*;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.*;
import java.util.*;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
import org.jhotdraw.xml.DOMStorable;
/**
 * Represents an ISA (Generalization/Specialization) element in a Conceptual
 * Entity-Relationship Model.
 * 
 * @author Werner Randelshofer
 * @version 1.1 2006-02-21 Support for super-sub-type added.
 * <br>1.0 30. Januar 2004  Created.
 */
public class CERISA extends AbstractElement 
implements DOMStorable {
    
    private boolean isDisjoint;
    
    /** Creates a new instance. */
    public CERISA() {
    }
    
    protected CERAttribute createAttribute() {
        return new CERAttribute();
    }

    public void setDisjoint(boolean newValue) {
        boolean oldValue = isDisjoint;
        isDisjoint = newValue;
        firePropertyChange("disjoint", oldValue, newValue);
    }
    public boolean isDisjoint() {
        return isDisjoint;
    }
    
    public List<CERConnection> getGeneralizations() {
        LinkedList<CERConnection> generalizations = new LinkedList<CERConnection>();
        for (SimulatedRelationship c : getRelationships(ConceptualERModel.GENERALIZATION)) {
                generalizations.add((CERConnection) c);
        }
        return generalizations;
    }
    public List<CERConnection> getSpecializations() {
        LinkedList<CERConnection> specializations = new LinkedList<CERConnection>();
        for (SimulatedRelationship c : getRelationships(ConceptualERModel.SPECIALIZATION)) {
                specializations .add((CERConnection) c);
        }
        return specializations ;
    }
    public Collection<CERISA> getRelatedEntities() {
        LinkedList<CERISA> entities = new LinkedList<CERISA>();
        for (SimulatedElement e : getRelatedElements()) {
            if (e.getSimulatedConcept() == ConceptualERModel.ENTITY_SET) {
                entities.add((CERISA) e);
            }
        }
        return entities;
    }
    
    public int getSimulatedConcept() {
        return ConceptualERModel.ISA;
    }
    
    public CERISA clone() {
        CERISA that = (CERISA) super.clone();
        
        // XXX - Clone the generalization connection properly
        return that;
    }
    
    public void read(DOMInput in) {
        isDisjoint = in.getAttribute("disjoint", false);
    }
    
    public void write(DOMOutput out) {
        out.addAttribute("disjoint", isDisjoint, false);
    }    
    public ConceptualERModel getERModel() {
        return (ConceptualERModel) getSimulation();
    }
    
    public boolean isEquivalent(SimulatedObject o) {
        if (super.isEquivalent(o) && (o instanceof CERISA)) {
            CERISA that = (CERISA) o;
            
            // FIXME - Add more criteria
            if (that.isDisjoint() == this.isDisjoint()) {
                return true;
            }
        }
        return false;
    }
}
